#include "h/oled.h"
#include "h/show.h"
#include "h/uart.h"

/*
void showReceiveBuffer(int y, BYTE numBytes)
{
	int i;

	
	setcursor_ezlcd(0, y);
	writestring_ezlcd((BYTE*)"Received: ");
	for(i=0; i<numBytes; i++)
	{
	disafree(receiveBuffer[i]);
	writec_ezlcd('.');
	}
}
*/

void showBuffer(int ycursor, BYTE* inptr, int numberBytes)
{
	int i, j;
	
	i=0;
	while(numberBytes>0)
	{
	//setCursorOLED(0, ycursor);
	//diswordfreeOLED(i);
	//writecOLED(' ');
	disIntUART(i);
	sendUART(' ');
		j=0;
		while((j<8)&&(numberBytes>0))
		{
		//disafreeOLED(*inptr);
		disAUART(*inptr);
		inptr++;
		//writecOLED(' ');
		sendUART(' ');
		j++;
		i++;
		numberBytes--;
		}
		sendUART(0x0A);
		sendUART(0x0D);
	ycursor+=1;
	}
	sendUART(0x0A);
	sendUART(0x0D);
}

void showCID(CARD_INFO* thisCard)
{
#if(USE_OLED)
	writeStringAtOLED(0, 4, "MID: ");
	disafreeOLED(thisCard->cid.MID);

	writeStringAtOLED(8, 4, "OID: ");
	diswordfreeOLED(thisCard->cid.OID);

	writeStringAtOLED(0, 5, "Name: ");
	writeStringOLED((char*)&thisCard->cid.PNM[0]);

	writeStringAtOLED(0, 6, "Rev: ");
	disafreeOLED(thisCard->cid.PRV);

	writeStringAtOLED(0, 7, "Serial: ");
	disafreeOLED(thisCard->cid.PSN[0]);
	disafreeOLED(thisCard->cid.PSN[1]);
	disafreeOLED(thisCard->cid.PSN[2]);
	disafreeOLED(thisCard->cid.PSN[3]);

	writeStringAtOLED(0, 8, "Date: ");
	diswordfreeOLED(thisCard->cid.MDT);
#endif

#if(USE_DEBUG)
	sendStringUART((BYTE*)"MID: ");
	disAUART(thisCard->cid.MID);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"OID: ");
	disIntUART(thisCard->cid.OID);

	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"Name: ");
	sendStringUART((BYTE*)&thisCard->cid.PNM[0]);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"Rev: ");
	disAUART(thisCard->cid.PRV);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"Serial: ");
	disAUART(thisCard->cid.PSN[0]);
	disAUART(thisCard->cid.PSN[1]);
	disAUART(thisCard->cid.PSN[2]);
	disAUART(thisCard->cid.PSN[3]);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"Date: ");
	disIntUART(thisCard->cid.MDT);
	sendUART(0x0A);
	sendUART(0x0D);

#endif
}

void showCSD(CARD_INFO* thisCard)
{
	#if(USE_OLED)
	writeStringAtOLED(0, 0, "TAAC: ");
	disafreeOLED(thisCard->csd.TAAC);
	
	writeStringAtOLED(8, 0, "NSAC: ");
	diswordfreeOLED(thisCard->csd.NSAC);

	writeStringAtOLED(0, 1, "TRAN_SPEED: ");
	disafreeOLED(thisCard->csd.TRAN_SPEED);

	writeStringAtOLED(0, 2, "CCC: ");
	diswordfreeOLED(thisCard->csd.CCC);

	writeStringAtOLED(0, 3, "READ_BL_LEN: ");
	disafreeOLED(thisCard->csd.READ_BL_LEN);

	writeStringAtOLED(0, 4, "C_SIZE: ");
	diswordfreeOLED(thisCard->csd.C_SIZE);

	writeStringAtOLED(0, 5, "C_SIZE_MULT: ");
	disafreeOLED(thisCard->csd.C_SIZE_MULT);

	writeStringAtOLED(0, 6, "SECTOR_SIZE: ");
	disafreeOLED(thisCard->csd.SECTOR_SIZE);

	writeStringAtOLED(0, 7, "FILE FORMAT: ");
	disafreeOLED(thisCard->csd.FILE_FORMAT);

	writeStringAtOLED(0, 8, "SIZE: ");
	disafreeOLED(thisCard->SIZE>>56);
	disafreeOLED(thisCard->SIZE>>48);
	disafreeOLED(thisCard->SIZE>>40);
	disafreeOLED(thisCard->SIZE>>32);
	disafreeOLED(thisCard->SIZE>>24);
	disafreeOLED(thisCard->SIZE>>16);
	disafreeOLED(thisCard->SIZE>>8);
	disafreeOLED(thisCard->SIZE);
#endif


#if(USE_DEBUG)
	sendStringUART((BYTE*)"TAAC: ");
	disAUART(thisCard->csd.TAAC);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"NSAC: ");
	disAUART(thisCard->csd.NSAC);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"TRAN_SPEED: ");
	disAUART(thisCard->csd.TRAN_SPEED);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"CCC: ");
	disIntUART(thisCard->csd.CCC);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"READ_BL_LEN: ");
	disAUART(thisCard->csd.READ_BL_LEN);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"READ_BL_PARTIAL: ");
	disAUART(thisCard->csd.READ_BL_PARTIAL);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"WRITE_BL_PARTIAL: ");
	disAUART(thisCard->csd.WRITE_BL_PARTIAL);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"C_SIZE: ");
	disIntUART(thisCard->csd.C_SIZE);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"C_SIZE_MULT: ");
	disAUART(thisCard->csd.C_SIZE_MULT);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"SECTOR_SIZE: ");
	disAUART(thisCard->csd.SECTOR_SIZE);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"FILE FORMAT: ");
	disAUART(thisCard->csd.FILE_FORMAT);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"SIZE: ");
	disAUART(thisCard->SIZE>>56);
	disAUART(thisCard->SIZE>>48);
	disAUART(thisCard->SIZE>>40);
	disAUART(thisCard->SIZE>>32);
	disAUART(thisCard->SIZE>>24);
	disAUART(thisCard->SIZE>>16);
	disAUART(thisCard->SIZE>>8);
	disAUART(thisCard->SIZE);
	sendUART(0x0A);
	sendUART(0x0D);




#endif
}

void showCardInfo(CARD_INFO* thisCard)
{
#if(USE_OLED)
	writeStringAtOLED(0, 0, "CARD_TYPE:  ");
	disafreeOLED(thisCard->CARD_TYPE);

	writeStringAtOLED(0, 1, "VOLT_RANGE: ");
	disafreeOLED(thisCard->VOLTAGE_RANGE);

	writeStringAtOLED(0, 2, "ERROR:      ");
	disafreeOLED(thisCard->ERROR);
#endif

#if(USE_DEBUG)
	sendStringUART((BYTE*)"CARD_TYPE:  ");
	disAUART(thisCard->CARD_TYPE);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"VOLT_RANGE: ");
	disAUART(thisCard->VOLTAGE_RANGE);
	sendUART(0x0A);
	sendUART(0x0D);

	sendStringUART((BYTE*)"ERROR:      ");
	disAUART(thisCard->ERROR);
	sendUART(0x0A);
	sendUART(0x0D);

#endif


}
